﻿function openCube(pId, pParams) {
    var szParam = "'pId' : '" + pId + "', 'pParams':'" + pParams + "'";
    $.ajax({
        url: getCubeShowExistsURL(),
        type: 'POST',
        data: '{' + szParam + '}',
        dataType: "json",
        cache: false,
        contentType: "application/json; charset=utf-8",
        async: true,
        success: function (resp) {
            if (resp.status === 200) {
                jsondata = resp.data;
                if (jsondata.Exists === 1)
                    location.href = getCubeShowURL() + '?pId=' + pId + '&pParams=' + pParams;
                else
                    alert(cubCubeNotExists);
            }
            else if (resp.status === 302) {
                window.location.href = resp.data;
            }
            else if (resp.status === 500) {
                alert(resp.data);
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            Common.ShowError(xhr, ajaxOptions, thrownError);
        }
    });
};
function getCubeLastUpdate(pId, pParams) {
    var szParam = "'pId' : '" + pId + "', 'pParams':'" + pParams + "'";
    $.ajax({
        url: getCubeShowExistsURL(),
        type: 'POST',
        data: '{' + szParam + '}',
        dataType: "json",
        cache: false,
        contentType: "application/json; charset=utf-8",
        async: true,
        success: function (resp) {
            if (resp.status === 200) {
                jsondata = resp.data;
                if (jsondata.Exists === 1) {
                    $("#spnjb" + pId).text(moment(jsondata.LastUpdate).format("L") + ' ' + moment(jsondata.LastUpdate).format("HH:mm:ss"));
                    $("#btnjb" + pId).prop('disabled', false);
                }
                else {
                    $("#btnjb" + pId).prop('disabled', true);
                    $("#spnjb" + pId).text(cubCubeNotExists);
                }
            }
            else if (resp.status === 302) {
                window.location.href = resp.data;
            }
            else if (resp.status === 500) {
                alert(resp.data);
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            Common.ShowError(xhr, ajaxOptions, thrownError);
        },
        always: function () {
        }
    });
};
function showCubes(src) {
    $("#inboxHeader").text(src.dataset.title);
    var infoJson = JSON.parse(src.dataset.info);
    var params = src.dataset.params;
    $("#inbox").DataTable({
        data: infoJson,
        destroy: true,
        paging: false,
        ordering: false,
        info: false,
        serverSide: false,
        order: [],
        searching: false,
        drawCallback: function (settings) {
            $('#inboxContainer').show();
        },
        columns: [
            { name: 'Function', data: null, title: "", sortable: false, searchable: false },
            { name: 'Description', data: 'Description', title: cubDescription, sortable: true, searchable: false },
            { name: 'JobId', data: 'JobId', title: '#', visible: true, sortable: false, searchable: false },
            { name: 'LastUpdate', data: null, title: cubLastUpdate, visible: true, sortable: false, searchable: false }
        ],
        columnDefs: [
            {
                targets: [0],
                width: '5%',
                render: function (data, type, full, meta) {
                    var ctrl = '';
                    ctrl += "<button id='btnjb" + data.JobId + "' class='btn btn-default btn-flat' disabled type='button' onclick='openCube(" +
                        data.JobId + ",\"" + params + "\");'><i class='fa fa-download'></i> </button>";
                    return ctrl;
                    //fa-file-excel-o
                }
            },
            {
                targets: [1], width: '60%'
            },
            {
                targets: [2],
                className: "dt-center"
            },
            {
                 targets: [3],
                 className: "dt-center",
                 render: function (data, type, full, meta) {
                     return "<span id='spnjb" + data.JobId + "'><span><i data-type='icon' class='fa fa-spinner' style='animation:spin 2s linear infinite;'></i></span></span>";
                 }
             }

        ],
        createdRow: function (row, data, dataIndex) {
            getCubeLastUpdate(data.JobId, params);
        }
    });
}
